﻿using System;
using System.Collections.Generic;
using System.Web.UI;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.BusinessManager;
using VeteransAffairs.Registries.BusinessManager.EFR;
using System.Text.RegularExpressions;
using System.Web.Security.AntiXss;

public partial class DoDFragmentAnalyte : BasePage
{
    private DoDFragmentManager _manager = new DoDFragmentManager();
    protected readonly string DoDFragmentPage = "DoDFragment.aspx?patientId=";

    protected void Page_Load(object sender, EventArgs e)
    {
        LoadBaseControls();

        if (!IsPostBack)
        {
            HiddenFieldPatientID.Value = AntiXssEncoder.HtmlEncode(Request.QueryString["patientId"], false);
            HiddenFieldAnalyteID.Value = AntiXssEncoder.HtmlEncode(Request.QueryString["dodFragmentAnalyteId"], false);
            HiddenFieldFragmentID.Value = AntiXssEncoder.HtmlEncode(Request.QueryString["dodFragmentId"], false);
        }

        if (string.IsNullOrEmpty(HiddenFieldAnalyteID.Value))
        {
         BreadCrumbLabel.Text = "Patients > Patient Lookup > Workflows > DoD Fragment Data > Add Analyte Data" ;
       }
        else
        {
        BreadCrumbLabel.Text = "Patients > Patient Lookup > Workflows > DoD Fragment Data > Edit Analyte Data" ;
        }


    }

    private void Page_PreRender(object sender, EventArgs e)
    {
        LoadControlsFromObject();
    }

    public override string TopMenuName()
    {
        return "Patients";
    }

    public override string AppObjectCode()
    {
        return "EFR_PATIENTS";
    }

    public override string MenuItemName()
    {
        return "EFR_PATIENTS";
    }

    private void LoadBaseControls()
    {
        RegistriesCommonManager commonManager = new RegistriesCommonManager();
        List<STD_GUI_CONTROL> controls = commonManager.GetStdGuiControlsByCategory("DOD_FRAGMENT_ANALYTE_DATA_ENTRY", EFRSharedConstant.EfrRegistryId);

        foreach (STD_GUI_CONTROL dbItem in controls)
        {
            Control userControl = null;

            if (dbItem.BASE_CONTROL_TYPE == (int) EfrBaseControlType.TextBox)
            {
                userControl = PanelAnalyte.FindControl(dbItem.USER_CONTROL_ID);
                if (userControl != null)
                {
                    controls_BaseControlTextBox baseControl = (controls_BaseControlTextBox)userControl;
                    baseControl.LoadControlsFromObject(string.Empty, dbItem.LABEL_TEXT,
                        dbItem.TOOL_TIP, dbItem.INCLUDE_LABEL, dbItem.DATA_TYPE_MAX_LENGTH, dbItem.DATA_ELEMENT_WIDTH);
                }
            }
            else if (dbItem.BASE_CONTROL_TYPE == (int)EfrBaseControlType.DropDownList)
            {
                userControl = PanelAnalyte.FindControl(dbItem.USER_CONTROL_ID);
                if (userControl != null)
                {
                    controls_BaseControlDropDownList baseControl = (controls_BaseControlDropDownList)userControl;
                    baseControl.LoadControlsFromObject(string.Empty, dbItem.LABEL_TEXT,
                        dbItem.TOOL_TIP, dbItem.INCLUDE_LABEL, dbItem.LOOKUP_LIST_CATEGORY);
                    if (dbItem.USER_CONTROL_ID == "BaseControlDropdownListAnalyte")
                    {
                        baseControl.SetValueAsText();
                    }
                }
            }
        }
    }


    protected void ButtonBack_Click(object sender, EventArgs e)
    {
        ResponseRedirect(DoDFragmentPage, GetQueryStringValue(HiddenFieldPatientID.Value));
    }

    private string GetQueryStringValue(string patientID)
    {
        string vldPatientId = string.Empty;

        if (IsQueryStringValid(patientID))
            vldPatientId = patientID.ToString();

        return vldPatientId;
    }

    private bool IsQueryStringValid(string patientID)
    {
        bool isStringValid = false;
        if (patientID != null)
        {
            if (Regex.IsMatch(patientID.ToString(), "^[a-zA-Z0-9]*$"))
            {
                isStringValid = true;
            }
        }
        return isStringValid;
    }
    protected void ButtonSave_Click(object sender, EventArgs e)
    {
        DOD_FRAGMENT_DETAIL analyte = LoadObjectFromControls();
        analyte = _manager.Update(analyte);
        HiddenFieldAnalyteID.Value = analyte.DOD_FRAGMENT_DETAIL_ID.ToString();

        ResponseRedirect(DoDFragmentPage, GetQueryStringValue(HiddenFieldPatientID.Value));
    }

    private DOD_FRAGMENT_DETAIL  LoadObjectFromControls()
    {
        DOD_FRAGMENT_DETAIL analyte = new DOD_FRAGMENT_DETAIL();

        if (!string.IsNullOrEmpty(HiddenFieldAnalyteID.Value)
            && HiddenFieldAnalyteID.Value != "0" )
        {
            analyte = _manager.GetFragmentAnalyteById(Helpers.GetIntFromString(HiddenFieldAnalyteID.Value));
            analyte.SetAsChangeTrackingRoot(false);
            analyte.SetAsUpdateOnSubmit();
        }
        else
        {
            analyte.SetAsChangeTrackingRoot();
            analyte.SetAsInsertOnSubmit();
            analyte.DOD_FRAGMENT_ID = Helpers.GetIntFromString(HiddenFieldFragmentID.Value);
        }

        analyte.ANALYTE = BaseControlDropdownListAnalyte.Text;
        analyte.ANALYSIS_METHOD = BaseControlTextBoxAnalysisMethod.Text;
        analyte.OTHER_ANALYTE = BaseControlTextBoxOtherAnalyte.Text;
        if (Helpers.GetIntFromString(BaseControlDropDownListAnalysisType.Text) > 0)
        {
            if (analyte.STD_FRAGMENT_ANALYSIS_TYPE != null)
            {
                analyte.STD_FRAGMENT_ANALYSIS_TYPE.ID = Helpers.GetIntFromString(BaseControlDropDownListAnalysisType.Text);
            }
            else
            {
                analyte.STD_FRAGMENT_ANALYSIS_TYPE = new STD_FRAGMENT_ANALYSIS_TYPE();
                analyte.STD_FRAGMENT_ANALYSIS_TYPE.ID = Helpers.GetIntFromString(BaseControlDropDownListAnalysisType.Text);
            }
        }
        else
        {
            analyte.STD_FRAGMENT_ANALYSIS_TYPE = null;
        }
        analyte.CAS_NUMBER = BaseControlTextBoxCasNumber.Text;
        analyte.RESULT = BaseControlTextBoxResult.Text;
        analyte.COMMENTS = BaseControlTextBoxComments.Text;

        return analyte;
    }


    private void LoadControlsFromObject()
    {
        if (!string.IsNullOrEmpty(HiddenFieldAnalyteID.Value)
            && HiddenFieldAnalyteID.Value != "0")
        {
            DOD_FRAGMENT_DETAIL analyte = _manager.GetFragmentAnalyteById(Helpers.GetIntFromString(HiddenFieldAnalyteID.Value));
            BaseControlDropdownListAnalyte.Text = analyte.ANALYTE;
            BaseControlTextBoxAnalysisMethod.Text = analyte.ANALYSIS_METHOD;
            BaseControlTextBoxOtherAnalyte.Text = analyte.OTHER_ANALYTE;
            if (analyte.STD_FRAGMENT_ANALYSIS_TYPE_ID != null)
            {
                BaseControlDropDownListAnalysisType.Text = analyte.STD_FRAGMENT_ANALYSIS_TYPE_ID.ToString();
            }
            BaseControlTextBoxCasNumber.Text = analyte.CAS_NUMBER;
            BaseControlTextBoxResult.Text = analyte.RESULT;
            BaseControlTextBoxComments.Text = analyte.COMMENTS;
        }
    }

    private void ResponseRedirect(string destination, string queryString)
    { 
        string queryStringValue = string.Empty;
        if (queryString != null)
            queryStringValue = AntiXssEncoder.UrlEncode(queryString);		 

        string destinationUrl = string.Concat(destination, queryStringValue);
        string currentHost = Request.Url.Host;
        if (Helpers.IsDestinationUrlLocal(destinationUrl, currentHost))
            Server.Transfer(destinationUrl);
    }
}
